// CheckTrView.h : interface of the CCheckTrView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHECKTRVIEW_H__C035B9D8_DAA2_486B_9EEE_A1816017EF78__INCLUDED_)
#define AFX_CHECKTRVIEW_H__C035B9D8_DAA2_486B_9EEE_A1816017EF78__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GDIUtil.h"

class CCheckTrView : public CView
{
protected: // create from serialization only
	CCheckTrView();
	DECLARE_DYNCREATE(CCheckTrView)

// Attributes
public:

	GHandle m_dib;

	CCheckTrDoc* GetDocument();

	void SendMessage(int mesage);
	LRESULT Mes_Anal(WPARAM,LPARAM);
	int Newton1(double pnt, int lng, double *arr);
	int Newton2(int pnt, int str1, int end1, int *arr);
	void BoxCarF(int param1, int lng, int *DataArray);
	void ColorSpectraMultiplying(double *SourceSpectra,double *WlgthSpectra,int ArLength1,double *ResultsData);
	void OnGetspeck();
	void OnMoveAddress();
	void OnOne();
	void OnZerro();
	void OnThree();
	void OnTwo();
	void BaselineCorr1(int Speclength, int windowG, int iterations, double *SpecArray);
	void CalibrationCoeffToMemory();
	void SaveServece(unsigned char *ArryaToWrite, int LenghtOfArrayToWrite);
	void AutoSaveSpec();

	void SaveSpec1(CString File_Name);//Save spectra, txt
	void SaveSpec2(CString File_Name);//Save screen, bmp
	void SaveSpec3(CString File_Name);//Save, 1nm step
	void SaveSpec4(CString File_Name);//Save, 380-760nm normalized to sensitivity
	void GaussT(int LengthArr);

	void TDGraph(CDC*dc_Frame,
							 double SN,
							 double Xmin,
							 double Xmax,
							 double Ymin,
							 double Ymax,
							 double*SpectraData,
							 double*SpectraWavelength,
							 int*SpectraLength,
							 int*SpectraColorR,
							 int*SpectraColorG,
							 int*SpectraColorB,
							 int*SpectraColorW);

	bool InitCCD;
	bool firstStart;
	bool ShowReport;
	bool Test;
	bool Fast;
	bool Average;
	bool Log;
	bool DevDet;
	bool ShowReportTmp;
	int ExpN;
	int toDetach;
	int mesage_to; //0 - one comand; 1 - start scan and return spectra; 2 - return spectra
//	CClientDC* clientDC;
	unsigned char DataIn[200];
	unsigned char DataOut[256];
	double Xscl_lmbd[4096];

	double SourceSpectra[4096];
	bool RefSpectra;
	int MinRef_or_DevRef;
	bool ConcentrationSet;//molar concentration parameters set
	double MolExt;//molar absorptivity (extinction coefficient) of the absorber
	double CuvLength;//cuvette length

	double LoadedSpectra[4096];
	double LoadedXSpectra[4096];
	double LocLoadSpec[4096];
	int LoadSpecFlag;

	double lmbdMin;
	double lmbdMax;
	int Xscl_pix[4096];
	double Spectra[4096*64];
	double Spectra1[4096*64];
	double Background[4096];
	bool SpecToGet;
	bool Run_get_spec;
	int RLn;
	int TransNmb;
	
	int width;
	int high;
	int Xmargin_left;
	int Xmargin_right;
	int Ymargin_top;
	int Ymargin_bottom;
	CRect rect;
	
	int Blank; //number of blank messages between scans
	int NScans; //number of scans
	bool Trigger;
	bool KeepTrigger;
	bool StartEx;
	bool botDwn;
	bool LeftBot;
	int zoomDownX;
	int zoomUpX;
	int zoomDownY;
	int zoomUpY;
	bool sendOne;
	unsigned char Back1;	//0 - not possible to substract background
							//1 - nedds to get background
							//2 - background is taken but no substraction
							//3 - substract background from current spectra
	bool applBck;
	double coeff_A, coeff_B, coeff_C; //A*pixel^2+B*pixel+C=lambda;
	double bck_a, bck_b;
	bool getCoeff, getCoeff2;
	bool norm_Spec;
	double NormS[4096];
	double ColorNorm[4096];
	int LoadS;
	bool applyNorm;
	bool applyCal;
	unsigned __int32 addressF;
	unsigned __int16 MaxX, MinX, TotStartPix, TotEndPix;
	unsigned __int16 MaxXT, MinXT;
	bool SclDir;
	double MaxY, MinY;
	int TotPix;

	double ref_line;//in nm
	int ref_line_pixel;//pixel number in CCD
	int ref_line_index;//index number in SpectraWavelength_T
	int ref_line_pos;//pixel on the screen

	bool ShowMaxInt; //show maximum intensity on the graph

	unsigned char DirectWrite[8];
	unsigned char BoxCarN;
	bool ColBar; //color bar
	bool Stable1;
	bool GaussAppr;
	char InfoString[32];//information about device (from FLASH)
	unsigned char LoadedData[8192+8250+4096+100];
	bool SaveCalibrationAskUser;
	bool AllClbrToFLASH;//all calibration to FLASH process (true if there is process saving all calibration to FLASH (ABC, info string, norm and colornorm)
	bool XYSpace;	
	double Xcolor;
	double Ycolor;
	double Zcolor;
	double colorSize; //xyz picture size 
	double Ucolor;
	double Vcolor;
	int TTemp;
	double DCcolor;
	double CRI_Results[50];
	double Temper1;//temp
	bool	CalcEnDistr;
	bool	XYZ_CRI_calibr;
	double	LowRange;
	double	UpperRange;
	double	LowRange1;
	double	UpperRange1;
	double	LowRange2;
	double	UpperRange2;
	double	LowRange3;
	double	UpperRange3;
	double	ExpCorrect;
	double	EnergyCorrect;

	int conn_Dev; //connected devices
	int select_Dev;//selected device

	int windowG;//for baseline correction
	int iterations;//for baseline correction
	bool AutoY;//false no dynamic auto Y; true auto Y
	int PosMaxY;//position of max index
	bool CMscaleView;//true - x-scale in 1/cm; false - x-scale in nm
	bool AutoSave;
	int AutoMinutes;
	CString AutoDir;
	int AutoNmb;//specra number
	bool AutoSave1;//Save spectra, txt
	bool AutoSave2;//Save screen, bmp
	bool AutoSave3;//Save, 1nm step
	bool AutoSave4;//Save, 380-760nm normalized to sensitivity

	double SN_T;
	double SpectraData_T[1000000];
	double SpectraWavelength_T[1000000];
	int    SpectraLength_T[100];
	int    SpectraColorR_T[100];//red -RGB; 4 - line width
	int    SpectraColorG_T[100];//green -RGB; 4 - line width
	int    SpectraColorB_T[100];// blue -RGB; 4 - line width
	int    SpectraColorW_T[100];//line width; 4 - line width

	double A_V;
	double X0_V;
	double dX_V;
	double B_V;
	int GaussIndex;//index of the Gauss approximation in the all spectra list
	double Spec[4000];
	double Data[4000];
	double GaussData[4000];
	double slopeIndex;
	bool reset;
	int		ExpTimerCount;

	bool noTrig;
	bool OptTrig;
	bool ExtTrig;
	bool BothEdgesElectr;
	bool OneTimeElectr;
	bool FallEdgeElectr;
	bool FallEdgeOneTineOpt;
	bool FallEdgeOpt;
	bool RisingEdgeElectr;
	bool RisingEdgeOneTimeOpt;
	bool RisingEdgeOpt;
	bool ThreshOpt;
	double TrigIntensity;
	double TrigWavelength;
	int TrigStat; //0-no trig; 1-ext.trig; 2-optical trig.
	unsigned char	TrigEnableMode,
	unsigned char	TrigSignalFrontMode;
	unsigned char	enableMode;
	unsigned __int16 pixel;
	unsigned __int16 threshold;
	
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCheckTrView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCheckTrView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CCheckTrView)
	afx_msg void OnMessage();
	afx_msg void OnSpecSave();
	afx_msg void OnCalibration();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnFileSave1();
	afx_msg void OnGetbck();
	afx_msg void OnXyautoscale();
	afx_msg void OnXautoscale();
	afx_msg void OnYautoscale();
	afx_msg void OnFast();
	afx_msg void OnSetscale();
	afx_msg void OnEditCopy();
	afx_msg void OnSbstrbck();
	afx_msg void OnAveraging();
	afx_msg void OnRun();
	afx_msg void OnGetspectra();
	afx_msg void OnLoadsourcespectra();
	afx_msg void OnRef_min_Sp();
	afx_msg void OnSp_dev_Ref();
	afx_msg void OnOpenSpectra();
	afx_msg void OnFileOpen1();
	afx_msg void OnRadLog1();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnVIEW400to700();
	afx_msg void OnAbout();
	afx_msg void OnXyspace();
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintPreview();
	afx_msg void OnChoosespectr();
	afx_msg void OnXyzminus();
	afx_msg void OnXyzplus();
	afx_msg void OnCnstr();
	afx_msg void OnLog();
	afx_msg void OnBaseline();
	afx_msg void OnAutoy();
	afx_msg void OnViewCm();
	afx_msg void OnViewNm();
	afx_msg void OnPlstClbr();
	afx_msg void OnSaveCalibration();
	afx_msg void OnLoadCalibration();
	afx_msg void OnPlanckcalibration();
	afx_msg void OnFileSaveOne();
	afx_msg void OnSavescreen();
	afx_msg void OnSaveCalibrationToFlash();
	afx_msg void OnFileSaveBmp();
	afx_msg void OnFileSaveXyz();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSnap();
	afx_msg void OnClearall();
	afx_msg void OnCalibrationOff();
	afx_msg void OnTrigger();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in CheckTrView.cpp
inline CCheckTrDoc* CCheckTrView::GetDocument()
   { return (CCheckTrDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHECKTRVIEW_H__C035B9D8_DAA2_486B_9EEE_A1816017EF78__INCLUDED_)
